/*
 * Decompiled with CFR 0.152.
 */
package com.belenus.util;

import com.belenus.util.CharArray;
import com.belenus.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Configurator {
    private static final Logger logger = Logger.getLogger((Class)(class$com$belenus$util$Configurator == null ? (class$com$belenus$util$Configurator = Configurator.class$("com.belenus.util.Configurator")) : class$com$belenus$util$Configurator));
    private static final char[] BACKSLASH = "\\".toCharArray();
    private static final char[] DOUBLE_BACKSLASH = "\\\\".toCharArray();
    public static final String[] TIME_MODIFIER = new String[]{"ms", "s", "min", "h"};
    public static final int[] TIME_MULTIPLIER = new int[]{1, 1000, 60000, 3600000};
    public static final String[] MEM_MODIFIER = new String[]{"kb", "k", "MB", "M"};
    public static final int[] MEM_MULTIPLIER = new int[]{1024, 1024, 0x100000, 0x100000};
    private Properties m_properties;
    private HashSet m_passwordNames = new HashSet();
    private String m_currentScopeName = "";
    private ArrayList m_scopes = new ArrayList();
    private HashMap m_scopeListMap = new HashMap();
    private HashSet m_nameSet = new HashSet();
    private HashMap m_configMap = new HashMap();
    private File m_includeDir;
    private static final String INCLUDE_IDENTIFIER = "include";
    private static final String RESOURCE_PREFIX = "resource:";
    static /* synthetic */ Class class$com$belenus$util$Configurator;

    public Configurator(Properties properties, String overridePrefix) {
        this.includeProperties(properties, new HashSet(), new HashSet());
        this.override(properties, overridePrefix);
    }

    public Configurator(Properties properties, String overridePrefix, File includeDir) throws IOException {
        this.m_includeDir = includeDir;
        this.includeProperties(properties, new HashSet(), new HashSet());
        this.override(properties, overridePrefix);
    }

    private void override(Properties properties, String overridePrefix) {
        if (overridePrefix != null) {
            if (!overridePrefix.endsWith(".")) {
                overridePrefix = overridePrefix + ".";
            }
            logger.info((Object)("Adding system properties with prefix \"" + overridePrefix + "\""));
            Properties systemProperties = System.getProperties();
            this.addProperties(properties, systemProperties, overridePrefix, true);
        }
        this.m_properties = properties;
    }

    private void addProperties(Properties properties, Properties additionalProperties, String prefix, boolean override) {
        Iterator<Object> additionalPropertiesKeysIterator = additionalProperties.keySet().iterator();
        while (additionalPropertiesKeysIterator.hasNext()) {
            String key = (String)additionalPropertiesKeysIterator.next();
            if (!key.startsWith(prefix)) continue;
            String keyWithoutPrefix = key.substring(prefix.length());
            if (!override && properties.containsKey(keyWithoutPrefix)) continue;
            String value = additionalProperties.getProperty(key);
            properties.setProperty(keyWithoutPrefix, value);
            if (!override) continue;
            logger.info((Object)("Overriding " + keyWithoutPrefix + "=" + value));
        }
    }

    private void includeProperties(Properties properties, HashSet includedFiles, HashSet includedResources) {
        String include = properties.getProperty(INCLUDE_IDENTIFIER);
        if (include != null) {
            String[] includes = StringUtil.split(include, ",", true);
            for (int includesIndex = 0; includesIndex < includes.length; ++includesIndex) {
                InputStream inputStream;
                Properties includedProperties;
                String includeNamePart = includes[includesIndex];
                if (includeNamePart.startsWith(RESOURCE_PREFIX)) {
                    String resourceName = includeNamePart.substring(RESOURCE_PREFIX.length());
                    if (includedResources.contains(resourceName)) continue;
                    try {
                        logger.info((Object)("Including resource " + resourceName));
                        includedResources.add(resourceName);
                        includedProperties = new Properties();
                        inputStream = this.getClass().getClassLoader().getResource(resourceName).openConnection().getInputStream();
                        includedProperties.load(inputStream);
                        this.includeProperties(includedProperties, includedFiles, includedResources);
                        this.addProperties(properties, includedProperties, "", false);
                    }
                    catch (Exception exception) {
                        logger.error((Object)("Including resource " + resourceName + " failed."));
                    }
                    continue;
                }
                String includeFileName = new File(this.m_includeDir, includeNamePart).getAbsoluteFile().toString();
                if (includedFiles.contains(includeFileName)) continue;
                try {
                    logger.info((Object)("Including file " + includeFileName));
                    includedFiles.add(includeFileName);
                    includedProperties = new Properties();
                    inputStream = new FileInputStream(includeFileName);
                    includedProperties.load(inputStream);
                    this.includeProperties(includedProperties, includedFiles, includedResources);
                    this.addProperties(properties, includedProperties, "", false);
                    continue;
                }
                catch (Exception exception) {
                    logger.error((Object)("Including file " + includeFileName + " failed."));
                }
            }
        }
    }

    private void addToScope(String name, Object value) {
        name = name.intern();
        ArrayList<Object[]> scopeList = (ArrayList<Object[]>)this.m_scopeListMap.get(this.m_currentScopeName);
        if (scopeList == null) {
            this.m_scopes.add(this.m_currentScopeName);
            scopeList = new ArrayList<Object[]>();
            this.m_scopeListMap.put(this.m_currentScopeName, scopeList);
        }
        if (!this.m_nameSet.contains(name)) {
            this.m_nameSet.add(name);
            scopeList.add(new Object[]{name, value});
        }
        if (!this.m_configMap.containsKey(name)) {
            this.m_configMap.put(name, value);
        }
    }

    public int getScopeCount() {
        return this.m_scopes.size();
    }

    public String getScopeName(int scopeIndex) {
        return (String)this.m_scopes.get(scopeIndex);
    }

    public int getEntryCount(String scopeName) {
        ArrayList scopeList = (ArrayList)this.m_scopeListMap.get(scopeName);
        return scopeList.size();
    }

    public String getEntryName(String scopeName, int entryIndex) {
        ArrayList scopeList = (ArrayList)this.m_scopeListMap.get(scopeName);
        Object[] nameValuePair = (Object[])scopeList.get(entryIndex);
        if (nameValuePair == null) {
            return null;
        }
        return (String)nameValuePair[0];
    }

    public Object getEntryValue(String scopeName, int entryIndex) {
        ArrayList scopeList = (ArrayList)this.m_scopeListMap.get(scopeName);
        Object[] nameValuePair = (Object[])scopeList.get(entryIndex);
        if (this.m_passwordNames.contains(nameValuePair[0])) {
            return "********";
        }
        if (nameValuePair == null) {
            return null;
        }
        return nameValuePair[1];
    }

    public void setEntryValue(String scopeName, String name, Object value) {
        ArrayList scopeList = (ArrayList)this.m_scopeListMap.get(scopeName);
        for (int scopeListIndex = 0; scopeListIndex < scopeList.size(); ++scopeListIndex) {
            Object[] nameValuePair = (Object[])scopeList.get(scopeListIndex);
            if (!nameValuePair[0].equals(name)) continue;
            nameValuePair[1] = value;
            return;
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        for (int scopeIndex = 0; scopeIndex < this.getScopeCount(); ++scopeIndex) {
            String scopeName = this.getScopeName(scopeIndex);
            int entryCount = this.getEntryCount(scopeName);
            result.append("# ").append(scopeName).append("\n");
            for (int entryIndex = 0; entryIndex < entryCount; ++entryIndex) {
                String entryName = this.getEntryName(scopeName, entryIndex);
                Object entryValue = this.getEntryValue(scopeName, entryIndex);
                if (entryValue != null) {
                    result.append(entryName).append("=");
                    if (this.m_passwordNames.contains(entryName)) {
                        result.append("********");
                    } else {
                        char[] entryChars = entryValue.toString().toCharArray();
                        entryChars = CharArray.replaceAll(entryChars, BACKSLASH, DOUBLE_BACKSLASH);
                        result.append(entryChars);
                    }
                } else {
                    result.append("#").append(entryName).append("=");
                }
                result.append("\n");
            }
        }
        return result.toString();
    }

    public void addPasswordName(String passwordName) {
        this.m_passwordNames.add(passwordName);
    }

    public void setScope(String scopeName) {
        this.m_currentScopeName = scopeName;
    }

    private String get(String name, String defaultString) {
        String returnString = this.m_properties.getProperty(name);
        if (returnString == null) {
            returnString = defaultString;
        }
        return returnString;
    }

    public String getString(String name, String defaultString) {
        String returnString = this.get(name, defaultString);
        this.addToScope(name, returnString);
        return returnString;
    }

    public boolean getBoolean(String name, String defaultString) {
        boolean result = Configurator.parseBoolean(this.get(name, defaultString), defaultString);
        this.addToScope(name, new Boolean(result));
        return result;
    }

    public int getInteger(String name, String defaultString) {
        int result = Configurator.parseInteger(this.get(name, defaultString), defaultString);
        this.addToScope(name, new Integer(result));
        return result;
    }

    public float getFloat(String name, String defaultString) {
        float result = Configurator.parseFloat(this.get(name, defaultString), defaultString);
        this.addToScope(name, new Float(result));
        return result;
    }

    public String[] getArray(String name) {
        String tag;
        String value;
        Vector<String> stringvector = new Vector<String>();
        int count = 0;
        while ((value = this.m_properties.getProperty(tag = name + "." + count)) != null) {
            ++count;
            stringvector.add(value);
        }
        Object[] resultstrings = new String[stringvector.size()];
        stringvector.copyInto(resultstrings);
        for (int i = 0; i < count; ++i) {
            this.addToScope(name + "." + i, resultstrings[i]);
        }
        return resultstrings;
    }

    public synchronized Object getObject(String name) {
        Object value = this.m_configMap.get(name);
        if (value == null) {
            String scope = this.m_currentScopeName;
            this.m_currentScopeName = "Not Specified";
            value = this.m_properties.getProperty(name);
            if (value != null) {
                this.addToScope(name, value);
            }
            this.m_currentScopeName = scope;
        }
        return value;
    }

    public int getModifiedInteger(String name, String defaultString, int[] multipliers, String[] modifiers) {
        String value = this.m_properties.getProperty(name);
        int result = Configurator.parseModifiedInteger(value, defaultString, multipliers, modifiers);
        this.addToScope(name, new Integer(result));
        return result;
    }

    public static int parseModifiedInteger(String value, String defaultString, int[] multipliers, String[] modifiers) {
        if (multipliers.length != modifiers.length) {
            throw new IllegalArgumentException("multiplier and modifier need be same length");
        }
        int multiplier = 1;
        for (int index = 0; index < modifiers.length; ++index) {
            if (!value.endsWith(modifiers[index])) continue;
            multiplier = multipliers[index];
            value = value.substring(0, value.length() - modifiers[index].length());
            break;
        }
        try {
            return Integer.parseInt(value) * multiplier;
        }
        catch (NumberFormatException nfe) {
            return Configurator.parseModifiedInteger(defaultString, null, multipliers, modifiers);
        }
    }

    public static float parseFloat(String value, String defaultString) {
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException nfe1) {
            try {
                return Float.parseFloat(defaultString);
            }
            catch (NumberFormatException nfe2) {
                return Float.NaN;
            }
        }
    }

    public static int parseInteger(String value, String defaultString) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe1) {
            try {
                return Integer.parseInt(defaultString);
            }
            catch (NumberFormatException nfe2) {
                return Integer.MIN_VALUE;
            }
        }
    }

    public static boolean parseBoolean(String returnstring, String defaultString) {
        boolean isValid = false;
        isValid |= returnstring.equalsIgnoreCase("true");
        if (!(isValid |= returnstring.equalsIgnoreCase("false"))) {
            returnstring = defaultString;
        }
        return returnstring.equalsIgnoreCase("true");
    }

    public Properties filterProperties(String prefix) {
        Properties filteredProperties = new Properties();
        Enumeration<?> propertyNames = this.m_properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String propertyName = (String)propertyNames.nextElement();
            if (!propertyName.startsWith(prefix + ".")) continue;
            String newPropertyName = propertyName.substring((prefix + ".").length());
            filteredProperties.setProperty(newPropertyName, this.m_properties.getProperty(propertyName));
            this.addToScope(propertyName, this.m_properties.getProperty(propertyName));
        }
        return filteredProperties;
    }

    public static Properties joinProperties(Properties highPriorityProperties, Properties lowPriorityPropeties) {
        Properties joinedProperties = new Properties(lowPriorityPropeties);
        joinedProperties.putAll((Map<?, ?>)highPriorityProperties);
        return joinedProperties;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

